/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.parsing.ast;

import beaver.Symbol;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.Problem;
import com.aptana.parsing.ast.IParseError;
import com.aptana.parsing.ast.Messages;

public class ParseError
extends Problem
implements IParseError {
    private String fLanguage;

    public ParseError(String language, Symbol symbol, IProblem.Severity severity) {
        this(language, symbol, null, severity);
    }

    public ParseError(String language, Symbol symbol, String message, IProblem.Severity severity) {
        this(language, symbol != null ? symbol.getStart() : 0, symbol != null ? symbol.getEnd() - symbol.getStart() + 1 : 0, message == null ? ParseError.buildErrorMessage(symbol) : message, severity);
    }

    public ParseError(String language, int offset, int length, String message, IProblem.Severity severity) {
        super(severity == null ? IProblem.Severity.WARNING.intValue() : severity.intValue(), message, offset, length, -1, null);
        this.fLanguage = language;
    }

    private static String buildErrorMessage(Symbol token) {
        StringBuilder builder = new StringBuilder();
        builder.append(Messages.ParseError_syntax_error_unexpected_token);
        builder.append('\"');
        builder.append(token.value);
        builder.append('\"');
        return builder.toString();
    }

    public String getLangauge() {
        return this.fLanguage;
    }
}

